package javabeansProprietesLiees;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class PointChaud
{
	private double temperature;
	
	private PropertyChangeSupport supportProprieteLiee;

	public PointChaud() {
		supportProprieteLiee = new PropertyChangeSupport(this);
	}

	public double getPointChaud() {
		return temperature;
	}
	
	public void setPointChaud(double temperature) {
		this.temperature = temperature;
		this.notifyTemperatureChange();
	}

	public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
		supportProprieteLiee.addPropertyChangeListener(l);
	}

	public void removePropertyChangeListener( PropertyChangeListener l ){
		supportProprieteLiee.removePropertyChangeListener( l ) ;
	}

	public void notifyTemperatureChange() {
		supportProprieteLiee.firePropertyChange("temperature", null, new Float(temperature));
	}
}

